/*
 * Decompiled with CFR 0.152.
 */
package br.com.stoacontroll.stoa.controller;

import br.com.stoacontroll.stoa.model.Agenda;
import br.com.stoacontroll.stoa.service.AgendaService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/agendas"})
public class AgendaController {
    private final AgendaService agendaService;

    @Autowired
    public AgendaController(AgendaService agendaService) {
        this.agendaService = agendaService;
    }

    @GetMapping
    public List<Agenda> getAllAgendas() {
        return this.agendaService.getAllAgendas();
    }

    @GetMapping(value={"/{id}"})
    public Optional<Agenda> getAgendaById(@PathVariable Long id) {
        return this.agendaService.getAgendaById(id);
    }

    @PostMapping
    public Agenda createAgenda(@RequestBody Agenda agenda) {
        return this.agendaService.createAgenda(agenda);
    }

    @PutMapping(value={"/{id}"})
    public Agenda updateAgenda(@PathVariable Long id, @RequestBody Agenda agendaDetails) {
        return this.agendaService.updateAgenda(id, agendaDetails);
    }

    @DeleteMapping(value={"/{id}"})
    public void deleteAgenda(@PathVariable Long id) {
        this.agendaService.deleteAgenda(id);
    }
}

