/*
 * Decompiled with CFR 0.152.
 */
package br.com.stoacontroll.stoa.controller;

import br.com.stoacontroll.stoa.model.Cliente;
import br.com.stoacontroll.stoa.service.ClienteService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/clientes"})
public class ClienteController {
    private final ClienteService clienteService;

    @Autowired
    public ClienteController(ClienteService clienteService) {
        this.clienteService = clienteService;
    }

    @GetMapping
    public List<Cliente> getAllClientes() {
        return this.clienteService.getAllClientes();
    }

    @GetMapping(value={"/{id}"})
    public Optional<Cliente> getClienteById(@PathVariable Long id) {
        return this.clienteService.getClienteById(id);
    }

    @PostMapping
    public Cliente createCliente(@RequestBody Cliente cliente) {
        return this.clienteService.createCliente(cliente);
    }

    @PutMapping(value={"/{id}"})
    public Cliente updateCliente(@PathVariable Long id, @RequestBody Cliente clienteDetails) {
        return this.clienteService.updateCliente(id, clienteDetails);
    }

    @DeleteMapping(value={"/{id}"})
    public void deleteCliente(@PathVariable Long id) {
        this.clienteService.deleteCliente(id);
    }
}

