/*
 * Decompiled with CFR 0.152.
 */
package br.com.stoacontroll.stoa.controller;

import br.com.stoacontroll.stoa.model.Empresa;
import br.com.stoacontroll.stoa.model.Procedimento;
import br.com.stoacontroll.stoa.service.EmpresaService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/empresas"})
public class EmpresaController {
    private final EmpresaService empresaService;

    @Autowired
    public EmpresaController(EmpresaService empresaService) {
        this.empresaService = empresaService;
    }

    @GetMapping
    public ResponseEntity<List<Empresa>> getAllEmpresas() {
        List empresas = this.empresaService.getAllEmpresas();
        return new ResponseEntity((Object)empresas, (HttpStatusCode)HttpStatus.OK);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<Empresa> getEmpresaById(@PathVariable(value="id") Long id) {
        Optional empresa = this.empresaService.getEmpresaById(id);
        return empresa.map(value -> new ResponseEntity(value, (HttpStatusCode)HttpStatus.OK)).orElseGet(() -> new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND));
    }

    @PostMapping
    public ResponseEntity<Empresa> createEmpresa(@RequestBody Empresa empresa) {
        Empresa createdEmpresa = this.empresaService.createEmpresa(empresa);
        return new ResponseEntity((Object)createdEmpresa, (HttpStatusCode)HttpStatus.CREATED);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<Empresa> updateEmpresa(@PathVariable(value="id") Long id, @RequestBody Empresa empresa) {
        Empresa updatedEmpresa = this.empresaService.updateEmpresa(id, empresa);
        if (updatedEmpresa != null) {
            return new ResponseEntity((Object)updatedEmpresa, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteEmpresa(@PathVariable(value="id") Long id) {
        this.empresaService.deleteEmpresa(id);
        return new ResponseEntity((HttpStatusCode)HttpStatus.NO_CONTENT);
    }

    @GetMapping(value={"/{id}/procedimentos"})
    public ResponseEntity<List<Procedimento>> getProcedimentosByEmpresaId(@PathVariable(value="id") Long id) {
        List procedimentos = this.empresaService.getProcedimentosByEmpresaId(id);
        if (procedimentos != null && !procedimentos.isEmpty()) {
            return new ResponseEntity((Object)procedimentos, (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((HttpStatusCode)HttpStatus.NOT_FOUND);
    }
}

