/*
 * Decompiled with CFR 0.152.
 */
package br.com.stoacontroll.stoa.controller;

import br.com.stoacontroll.stoa.model.Horario;
import br.com.stoacontroll.stoa.service.HorarioService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/horarios"})
public class HorarioController {
    private final HorarioService horarioService;

    @Autowired
    public HorarioController(HorarioService horarioService) {
        this.horarioService = horarioService;
    }

    @GetMapping
    public List<Horario> getAllHorarios() {
        return this.horarioService.getAllHorarios();
    }

    @GetMapping(value={"/{id}"})
    public Optional<Horario> getHorarioById(@PathVariable Long id) {
        return this.horarioService.getHorarioById(id);
    }

    @PostMapping
    public Horario createHorario(@RequestBody Horario horario) {
        return this.horarioService.createHorario(horario);
    }

    @PutMapping(value={"/{id}"})
    public Horario updateHorario(@PathVariable Long id, @RequestBody Horario horarioDetails) {
        return this.horarioService.updateHorario(id, horarioDetails);
    }

    @DeleteMapping(value={"/{id}"})
    public void deleteHorario(@PathVariable Long id) {
        this.horarioService.deleteHorario(id);
    }
}

