/*
 * Decompiled with CFR 0.152.
 */
package br.com.stoacontroll.stoa.controller;

import br.com.stoacontroll.stoa.model.HorarioTrabalho;
import br.com.stoacontroll.stoa.service.HorarioTrabalhoService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/horarios-trabalho"})
public class HorarioTrabalhoController {
    private final HorarioTrabalhoService horarioTrabalhoService;

    @Autowired
    public HorarioTrabalhoController(HorarioTrabalhoService horarioTrabalhoService) {
        this.horarioTrabalhoService = horarioTrabalhoService;
    }

    @GetMapping
    public ResponseEntity<List<HorarioTrabalho>> getAllHorariosTrabalho() {
        List horariosTrabalho = this.horarioTrabalhoService.getAllHorariosTrabalho();
        return ResponseEntity.ok((Object)horariosTrabalho);
    }

    @PostMapping
    public ResponseEntity<HorarioTrabalho> createHorarioTrabalho(@RequestBody HorarioTrabalho horarioTrabalho) {
        HorarioTrabalho createdHorarioTrabalho = this.horarioTrabalhoService.createHorarioTrabalho(horarioTrabalho);
        return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).body((Object)createdHorarioTrabalho);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<HorarioTrabalho> updateHorarioTrabalho(@PathVariable Long id, @RequestBody HorarioTrabalho horarioTrabalho) {
        HorarioTrabalho updatedHorarioTrabalho = this.horarioTrabalhoService.updateHorarioTrabalho(id, horarioTrabalho);
        if (updatedHorarioTrabalho != null) {
            return ResponseEntity.ok((Object)updatedHorarioTrabalho);
        }
        return ResponseEntity.notFound().build();
    }

    @DeleteMapping(value={"/{id}"})
    public ResponseEntity<Void> deleteHorarioTrabalho(@PathVariable Long id) {
        this.horarioTrabalhoService.deleteHorarioTrabalho(id);
        return ResponseEntity.noContent().build();
    }

    @PostMapping(value={"/{horarioTrabalhoId}/associar-empresa/{empresaId}"})
    public ResponseEntity<String> associateHorarioEmpresa(@PathVariable Long horarioTrabalhoId, @PathVariable Long empresaId) {
        try {
            this.horarioTrabalhoService.associateHorarioEmpresa(horarioTrabalhoId, empresaId);
            return ResponseEntity.ok((Object)"Associa\u00e7\u00e3o realizada com sucesso!");
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().body((Object)"N\u00e3o foi poss\u00edvel associar o hor\u00e1rio de trabalho \u00e0 empresa.");
        }
    }
}

