/*
 * Decompiled with CFR 0.152.
 */
package br.com.stoacontroll.stoa.controller;

import br.com.stoacontroll.stoa.model.Procedimento;
import br.com.stoacontroll.stoa.model.Profissional;
import br.com.stoacontroll.stoa.service.ProcedimentoService;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/procedimentos"})
public class ProcedimentoController {
    private final ProcedimentoService procedimentoService;

    @Autowired
    public ProcedimentoController(ProcedimentoService procedimentoService) {
        this.procedimentoService = procedimentoService;
    }

    @GetMapping
    public List<Procedimento> getAllProcedimentos() {
        return this.procedimentoService.getAllProcedimentos();
    }

    @GetMapping(value={"/{id}"})
    public Optional<Procedimento> getProcedimentoById(@PathVariable Long id) {
        return this.procedimentoService.getProcedimentoById(id);
    }

    @PostMapping
    public Procedimento createProcedimento(@RequestBody Procedimento procedimento) {
        return this.procedimentoService.createProcedimento(procedimento);
    }

    @PutMapping(value={"/{id}"})
    public Procedimento updateProcedimento(@PathVariable Long id, @RequestBody Procedimento procedimentoDetails) {
        return this.procedimentoService.updateProcedimento(id, procedimentoDetails);
    }

    @DeleteMapping(value={"/{id}"})
    public void deleteProcedimento(@PathVariable Long id) {
        this.procedimentoService.deleteProcedimento(id);
    }

    @GetMapping(value={"/{id}/profissionais"})
    public List<Profissional> getProfissionaisByProcedimentoId(@PathVariable Long id) {
        return this.procedimentoService.getProfissionaisByProcedimentoId(id);
    }
}

