/*
 * Decompiled with CFR 0.152.
 */
package br.com.stoacontroll.stoa.controller;

import br.com.stoacontroll.stoa.model.Profissional;
import br.com.stoacontroll.stoa.service.ProfissionalService;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/profissionais"})
public class ProfissionalController {
    private final ProfissionalService profissionalService;

    @Autowired
    public ProfissionalController(ProfissionalService profissionalService) {
        this.profissionalService = profissionalService;
    }

    @GetMapping
    public List<Profissional> getAllProfissionais() {
        return this.profissionalService.getAllProfissionais();
    }

    @GetMapping(value={"/{id}"})
    public Optional<Profissional> getProfissionalById(@PathVariable Long id) {
        return this.profissionalService.getProfissionalById(id);
    }

    @PostMapping
    public Profissional createProfissional(@RequestBody Profissional profissional) {
        return this.profissionalService.createProfissional(profissional);
    }

    @PutMapping(value={"/{id}"})
    public Profissional updateProfissional(@PathVariable Long id, @RequestBody Profissional profissionalDetails) {
        return this.profissionalService.updateProfissional(id, profissionalDetails);
    }

    @DeleteMapping(value={"/{id}"})
    public void deleteProfissional(@PathVariable Long id) {
        this.profissionalService.deleteProfissional(id);
    }

    @PostMapping(value={"/{profissionalId}/associar-empresa/{empresaId}"})
    public ResponseEntity<String> associateProfissionalEmpresa(@PathVariable Long profissionalId, @PathVariable Long empresaId) {
        try {
            this.profissionalService.associateProfissionalEmpresa(profissionalId, empresaId);
            return ResponseEntity.ok((Object)"Associa\u00e7\u00e3o realizada com sucesso!");
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().body((Object)"N\u00e3o foi poss\u00edvel associar o profissional \u00e0 empresa.");
        }
    }

    @PostMapping(value={"/{profissionalId}/associar-horarios-trabalho"})
    public ResponseEntity<String> associateHorariosTrabalho(@PathVariable Long profissionalId, @RequestBody List<Long> horariosTrabalhoIds) {
        try {
            this.profissionalService.associateHorarioTrabalhoProfissional(profissionalId, horariosTrabalhoIds);
            return ResponseEntity.ok((Object)"Associa\u00e7\u00e3o de hor\u00e1rios de trabalho realizada com sucesso!");
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().body((Object)"N\u00e3o foi poss\u00edvel associar os hor\u00e1rios de trabalho ao profissional.");
        }
    }

    @PostMapping(value={"/{profissionalId}/associar-procedimento/{procedimentoId}"})
    public ResponseEntity<String> associateProfissionalProcedimento(@PathVariable Long profissionalId, @PathVariable Long procedimentoId) {
        try {
            this.profissionalService.associateProfissionalProcedimento(profissionalId, procedimentoId);
            return ResponseEntity.ok((Object)"Associa\u00e7\u00e3o realizada com sucesso!");
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().body((Object)"N\u00e3o foi poss\u00edvel associar o profissional ao procedimento.");
        }
    }

    @GetMapping(value={"/{profissionalId}/dias-disponiveis"})
    public ResponseEntity<List<LocalDate>> getDiasDisponiveis(@PathVariable Long profissionalId) {
        try {
            List diasDisponiveis = this.profissionalService.getDiasDisponiveis(profissionalId);
            return ResponseEntity.ok((Object)diasDisponiveis);
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().body(Collections.emptyList());
        }
    }

    @PostMapping(value={"/{profissionalId}/horarios-disponiveis"})
    public ResponseEntity<List<String>> getHorariosDisponiveis(@PathVariable Long profissionalId, @RequestBody Map<String, String> requestBody) {
        try {
            String dataString = requestBody.get("data");
            String procedimentoIdString = requestBody.get("procedimentoId");
            if (dataString == null || dataString.isEmpty() || procedimentoIdString == null || procedimentoIdString.isEmpty()) {
                return ResponseEntity.badRequest().body(Collections.emptyList());
            }
            LocalDate data = LocalDate.parse(dataString);
            Long procedimentoId = Long.parseLong(procedimentoIdString);
            List horariosDisponiveis = this.profissionalService.getHorariosDisponiveis(profissionalId, procedimentoId, data);
            return ResponseEntity.ok((Object)horariosDisponiveis);
        }
        catch (Exception e) {
            return ResponseEntity.badRequest().body(Collections.emptyList());
        }
    }
}

