/*
 * Decompiled with CFR 0.152.
 */
package br.com.stoacontroll.stoa.service;

import br.com.stoacontroll.stoa.model.Agenda;
import br.com.stoacontroll.stoa.model.Horario;
import br.com.stoacontroll.stoa.model.Profissional;
import br.com.stoacontroll.stoa.repository.AgendaRepository;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AgendaService {
    private final AgendaRepository agendaRepository;

    @Autowired
    public AgendaService(AgendaRepository agendaRepository) {
        this.agendaRepository = agendaRepository;
    }

    public List<Agenda> getAllAgendas() {
        return this.agendaRepository.findAll();
    }

    public Optional<Agenda> getAgendaById(Long id) {
        return this.agendaRepository.findById((Object)id);
    }

    public Agenda createAgenda(Agenda agenda) {
        return (Agenda)this.agendaRepository.save((Object)agenda);
    }

    public Agenda updateAgenda(Long id, Agenda agendaDetails) {
        Optional optionalAgenda = this.agendaRepository.findById((Object)id);
        if (optionalAgenda.isPresent()) {
            Agenda agenda = (Agenda)optionalAgenda.get();
            agenda.setProfissional(agendaDetails.getProfissional());
            agenda.setData(agendaDetails.getData());
            agenda.setHorariosAgendados(agendaDetails.getHorariosAgendados());
            return (Agenda)this.agendaRepository.save((Object)agenda);
        }
        return null;
    }

    public void deleteAgenda(Long id) {
        this.agendaRepository.deleteById((Object)id);
    }

    public List<Horario> getHorariosAgendadosPorProfissionalEData(Profissional profissional, LocalDate data) {
        List agendas = this.agendaRepository.findByProfissionalAndData(profissional, data);
        ArrayList<Horario> horariosAgendados = new ArrayList<Horario>();
        for (Agenda agenda : agendas) {
            horariosAgendados.addAll(agenda.getHorariosAgendados());
        }
        return horariosAgendados;
    }
}

