/*
 * Decompiled with CFR 0.152.
 */
package br.com.stoacontroll.stoa.service;

import br.com.stoacontroll.stoa.model.Cliente;
import br.com.stoacontroll.stoa.repository.ClienteRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ClienteService {
    private final ClienteRepository clienteRepository;

    @Autowired
    public ClienteService(ClienteRepository clienteRepository) {
        this.clienteRepository = clienteRepository;
    }

    public List<Cliente> getAllClientes() {
        return this.clienteRepository.findAll();
    }

    public Optional<Cliente> getClienteById(Long id) {
        return this.clienteRepository.findById((Object)id);
    }

    public Cliente createCliente(Cliente cliente) {
        return (Cliente)this.clienteRepository.save((Object)cliente);
    }

    public Cliente updateCliente(Long id, Cliente clienteDetails) {
        Optional optionalCliente = this.clienteRepository.findById((Object)id);
        if (optionalCliente.isPresent()) {
            Cliente cliente = (Cliente)optionalCliente.get();
            cliente.setNome(clienteDetails.getNome());
            cliente.setEmail(clienteDetails.getEmail());
            cliente.setTelefone(clienteDetails.getTelefone());
            cliente.setEndereco(clienteDetails.getEndereco());
            return (Cliente)this.clienteRepository.save((Object)cliente);
        }
        return null;
    }

    public void deleteCliente(Long id) {
        this.clienteRepository.deleteById((Object)id);
    }
}

