/*
 * Decompiled with CFR 0.152.
 */
package br.com.stoacontroll.stoa.service;

import br.com.stoacontroll.stoa.model.Empresa;
import br.com.stoacontroll.stoa.model.Procedimento;
import br.com.stoacontroll.stoa.repository.EmpresaRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EmpresaService {
    private final EmpresaRepository empresaRepository;

    @Autowired
    public EmpresaService(EmpresaRepository empresaRepository) {
        this.empresaRepository = empresaRepository;
    }

    public List<Empresa> getAllEmpresas() {
        return this.empresaRepository.findAll();
    }

    public Optional<Empresa> getEmpresaById(Long id) {
        return this.empresaRepository.findById((Object)id);
    }

    public Empresa createEmpresa(Empresa empresa) {
        return (Empresa)this.empresaRepository.save((Object)empresa);
    }

    public Empresa updateEmpresa(Long id, Empresa empresaDetails) {
        Optional optionalEmpresa = this.empresaRepository.findById((Object)id);
        if (optionalEmpresa.isPresent()) {
            Empresa empresa = (Empresa)optionalEmpresa.get();
            empresa.setNome(empresaDetails.getNome());
            empresa.setCnpj(empresaDetails.getCnpj());
            return (Empresa)this.empresaRepository.save((Object)empresa);
        }
        return null;
    }

    public void deleteEmpresa(Long id) {
        this.empresaRepository.deleteById((Object)id);
    }

    public List<Procedimento> getProcedimentosByEmpresaId(Long id) {
        Optional optionalEmpresa = this.empresaRepository.findById((Object)id);
        if (optionalEmpresa.isPresent()) {
            return ((Empresa)optionalEmpresa.get()).getProcedimentos();
        }
        return null;
    }
}

