/*
 * Decompiled with CFR 0.152.
 */
package br.com.stoacontroll.stoa.service;

import br.com.stoacontroll.stoa.model.Horario;
import br.com.stoacontroll.stoa.repository.HorarioRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HorarioService {
    private final HorarioRepository horarioRepository;

    @Autowired
    public HorarioService(HorarioRepository horarioRepository) {
        this.horarioRepository = horarioRepository;
    }

    public List<Horario> getAllHorarios() {
        return this.horarioRepository.findAll();
    }

    public Optional<Horario> getHorarioById(Long id) {
        return this.horarioRepository.findById((Object)id);
    }

    public Horario createHorario(Horario horario) {
        return (Horario)this.horarioRepository.save((Object)horario);
    }

    public Horario updateHorario(Long id, Horario horarioDetails) {
        Optional optionalHorario = this.horarioRepository.findById((Object)id);
        if (optionalHorario.isPresent()) {
            Horario horario = (Horario)optionalHorario.get();
            horario.setHorario(horarioDetails.getHorario());
            horario.setCliente(horarioDetails.getCliente());
            horario.setProcedimento(horarioDetails.getProcedimento());
            horario.setAgenda(horarioDetails.getAgenda());
            return (Horario)this.horarioRepository.save((Object)horario);
        }
        return null;
    }

    public void deleteHorario(Long id) {
        this.horarioRepository.deleteById((Object)id);
    }
}

