/*
 * Decompiled with CFR 0.152.
 */
package br.com.stoacontroll.stoa.service;

import br.com.stoacontroll.stoa.model.Empresa;
import br.com.stoacontroll.stoa.model.HorarioTrabalho;
import br.com.stoacontroll.stoa.repository.EmpresaRepository;
import br.com.stoacontroll.stoa.repository.HorarioTrabalhoRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class HorarioTrabalhoService {
    private final HorarioTrabalhoRepository horarioTrabalhoRepository;
    private final EmpresaRepository empresaRepository;

    @Autowired
    public HorarioTrabalhoService(HorarioTrabalhoRepository horarioTrabalhoRepository, EmpresaRepository empresaRepository) {
        this.horarioTrabalhoRepository = horarioTrabalhoRepository;
        this.empresaRepository = empresaRepository;
    }

    public List<HorarioTrabalho> getAllHorariosTrabalho() {
        return this.horarioTrabalhoRepository.findAll();
    }

    public HorarioTrabalho createHorarioTrabalho(HorarioTrabalho horarioTrabalho) {
        return (HorarioTrabalho)this.horarioTrabalhoRepository.save((Object)horarioTrabalho);
    }

    public HorarioTrabalho updateHorarioTrabalho(Long id, HorarioTrabalho horarioTrabalhoDetails) {
        Optional optionalHorarioTrabalho = this.horarioTrabalhoRepository.findById((Object)id);
        if (optionalHorarioTrabalho.isPresent()) {
            HorarioTrabalho horarioTrabalho = (HorarioTrabalho)optionalHorarioTrabalho.get();
            horarioTrabalho.setDiaSemana(horarioTrabalhoDetails.getDiaSemana());
            horarioTrabalho.setHorarioInicio(horarioTrabalhoDetails.getHorarioInicio());
            horarioTrabalho.setHorarioFim(horarioTrabalhoDetails.getHorarioFim());
            horarioTrabalho.setIntervaloInicio(horarioTrabalhoDetails.getIntervaloInicio());
            horarioTrabalho.setIntervaloFim(horarioTrabalhoDetails.getIntervaloFim());
            return (HorarioTrabalho)this.horarioTrabalhoRepository.save((Object)horarioTrabalho);
        }
        return null;
    }

    public void deleteHorarioTrabalho(Long id) {
        this.horarioTrabalhoRepository.deleteById((Object)id);
    }

    public void associateHorarioEmpresa(Long horarioTrabalhoId, Long empresaId) {
        Optional optionalHorarioTrabalho = this.horarioTrabalhoRepository.findById((Object)horarioTrabalhoId);
        Optional optionalEmpresa = this.empresaRepository.findById((Object)empresaId);
        if (optionalHorarioTrabalho.isPresent() && optionalEmpresa.isPresent()) {
            HorarioTrabalho horarioTrabalho = (HorarioTrabalho)optionalHorarioTrabalho.get();
            Empresa empresa = (Empresa)optionalEmpresa.get();
            horarioTrabalho.setEmpresa(empresa);
            this.horarioTrabalhoRepository.save((Object)horarioTrabalho);
        }
    }
}

