/*
 * Decompiled with CFR 0.152.
 */
package br.com.stoacontroll.stoa.service;

import br.com.stoacontroll.stoa.model.Procedimento;
import br.com.stoacontroll.stoa.model.Profissional;
import br.com.stoacontroll.stoa.repository.ProcedimentoRepository;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProcedimentoService {
    private final ProcedimentoRepository procedimentoRepository;

    @Autowired
    public ProcedimentoService(ProcedimentoRepository procedimentoRepository) {
        this.procedimentoRepository = procedimentoRepository;
    }

    public List<Procedimento> getAllProcedimentos() {
        return this.procedimentoRepository.findAll();
    }

    public Optional<Procedimento> getProcedimentoById(Long id) {
        return this.procedimentoRepository.findById((Object)id);
    }

    public Procedimento createProcedimento(Procedimento procedimento) {
        return (Procedimento)this.procedimentoRepository.save((Object)procedimento);
    }

    public Procedimento updateProcedimento(Long id, Procedimento procedimentoDetails) {
        Optional optionalProcedimento = this.procedimentoRepository.findById((Object)id);
        if (optionalProcedimento.isPresent()) {
            Procedimento procedimento = (Procedimento)optionalProcedimento.get();
            procedimento.setNome(procedimentoDetails.getNome());
            procedimento.setDuracaoMinutos(procedimentoDetails.getDuracaoMinutos());
            procedimento.setIntervaloMinutos(procedimentoDetails.getIntervaloMinutos());
            return (Procedimento)this.procedimentoRepository.save((Object)procedimento);
        }
        return null;
    }

    public void deleteProcedimento(Long id) {
        this.procedimentoRepository.deleteById((Object)id);
    }

    public List<Profissional> getProfissionaisByProcedimentoId(Long procedimentoId) {
        Optional optionalProcedimento = this.procedimentoRepository.findById((Object)procedimentoId);
        if (optionalProcedimento.isPresent()) {
            Procedimento procedimento = (Procedimento)optionalProcedimento.get();
            return procedimento.getProfissionais();
        }
        return null;
    }
}

