/*
 * Decompiled with CFR 0.152.
 */
package br.com.stoacontroll.stoa.service;

import br.com.stoacontroll.stoa.model.Empresa;
import br.com.stoacontroll.stoa.model.HorarioTrabalho;
import br.com.stoacontroll.stoa.model.Procedimento;
import br.com.stoacontroll.stoa.model.Profissional;
import br.com.stoacontroll.stoa.repository.EmpresaRepository;
import br.com.stoacontroll.stoa.repository.HorarioTrabalhoRepository;
import br.com.stoacontroll.stoa.repository.ProcedimentoRepository;
import br.com.stoacontroll.stoa.repository.ProfissionalRepository;
import jakarta.transaction.Transactional;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ProfissionalService {
    private final ProfissionalRepository profissionalRepository;
    private final EmpresaRepository empresaRepository;
    private final HorarioTrabalhoRepository horarioTrabalhoRepository;
    private final ProcedimentoRepository procedimentoRepository;

    @Autowired
    public ProfissionalService(ProfissionalRepository profissionalRepository, EmpresaRepository empresaRepository, HorarioTrabalhoRepository horarioTrabalhoRepository, ProcedimentoRepository procedimentoRepository) {
        this.profissionalRepository = profissionalRepository;
        this.empresaRepository = empresaRepository;
        this.horarioTrabalhoRepository = horarioTrabalhoRepository;
        this.procedimentoRepository = procedimentoRepository;
    }

    public List<Profissional> getAllProfissionais() {
        return this.profissionalRepository.findAll();
    }

    public Optional<Profissional> getProfissionalById(Long id) {
        return this.profissionalRepository.findById((Object)id);
    }

    public Profissional createProfissional(Profissional profissional) {
        return (Profissional)this.profissionalRepository.save((Object)profissional);
    }

    public Profissional updateProfissional(Long id, Profissional profissionalDetails) {
        Optional optionalProfissional = this.profissionalRepository.findById((Object)id);
        if (optionalProfissional.isPresent()) {
            Profissional profissional = (Profissional)optionalProfissional.get();
            profissional.setNome(profissionalDetails.getNome());
            profissional.setEspecialidade(profissionalDetails.getEspecialidade());
            List horariosTrabalhoDetails = profissionalDetails.getHorariosTrabalho();
            profissional.setHorariosTrabalho(horariosTrabalhoDetails);
            return (Profissional)this.profissionalRepository.save((Object)profissional);
        }
        return null;
    }

    public void deleteProfissional(Long id) {
        this.profissionalRepository.deleteById((Object)id);
    }

    public void associateProfissionalEmpresa(Long profissionalId, Long empresaId) {
        Optional optionalProfissional = this.profissionalRepository.findById((Object)profissionalId);
        Optional optionalEmpresa = this.empresaRepository.findById((Object)empresaId);
        if (optionalProfissional.isPresent() && optionalEmpresa.isPresent()) {
            Profissional profissional = (Profissional)optionalProfissional.get();
            Empresa empresa = (Empresa)optionalEmpresa.get();
            profissional.setEmpresa(empresa);
            this.profissionalRepository.save((Object)profissional);
        }
    }

    @Transactional
    public void associateHorarioTrabalhoProfissional(Long profissionalId, List<Long> horariosTrabalhoIds) {
        Profissional profissional = (Profissional)this.profissionalRepository.findById((Object)profissionalId).orElseThrow(() -> new IllegalArgumentException("Profissional n\u00e3o encontrado com o ID: " + profissionalId));
        List horariosTrabalho = this.horarioTrabalhoRepository.findAllById(horariosTrabalhoIds);
        profissional.getHorariosTrabalho().addAll(horariosTrabalho);
        horariosTrabalho.forEach(horario -> horario.getProfissionais().add(profissional));
    }

    public void associateProfissionalProcedimento(Long profissionalId, Long procedimentoId) {
        Profissional profissional = (Profissional)this.profissionalRepository.findById((Object)profissionalId).orElseThrow(() -> new IllegalArgumentException("Profissional n\u00e3o encontrado com o ID: " + profissionalId));
        Procedimento procedimento = (Procedimento)this.procedimentoRepository.findById((Object)procedimentoId).orElseThrow(() -> new IllegalArgumentException("Procedimento n\u00e3o encontrado com o ID: " + procedimentoId));
        profissional.getProcedimentos().add(procedimento);
        procedimento.getProfissionais().add(profissional);
        this.profissionalRepository.save((Object)profissional);
        this.procedimentoRepository.save((Object)procedimento);
    }

    public List<LocalDate> getDiasDisponiveis(Long profissionalId) {
        int qtdDiasAgenda = 7;
        Profissional profissional = (Profissional)this.profissionalRepository.findById((Object)profissionalId).orElseThrow(() -> new IllegalArgumentException("Profissional n\u00e3o encontrado com o ID: " + profissionalId));
        ArrayList<LocalDate> datasDisponiveis = new ArrayList<LocalDate>();
        LocalDate dataAtual = LocalDate.now();
        int diasEncontrados = 0;
        while (diasEncontrados < qtdDiasAgenda) {
            if (this.isDiaDisponivel(profissional, dataAtual)) {
                datasDisponiveis.add(dataAtual);
                ++diasEncontrados;
            }
            dataAtual = dataAtual.plusDays(1L);
        }
        return datasDisponiveis;
    }

    private boolean isDiaDisponivel(Profissional profissional, LocalDate data) {
        DayOfWeek diaSemana = data.getDayOfWeek();
        List horariosTrabalho = profissional.getHorariosTrabalho();
        for (HorarioTrabalho horario : horariosTrabalho) {
            if (horario.getDiaSemana().getValor() != diaSemana.getValue()) continue;
            return true;
        }
        return false;
    }

    public List<String> getHorariosDisponiveis(Long profissionalId, Long procedimentoId, LocalDate data) {
        ArrayList<String> horariosDisponiveis = new ArrayList<String>();
        Profissional profissional = (Profissional)this.profissionalRepository.findById((Object)profissionalId).orElseThrow(() -> new IllegalArgumentException("Profissional n\u00e3o encontrado com o ID: " + profissionalId));
        Procedimento procedimento = (Procedimento)this.procedimentoRepository.findById((Object)procedimentoId).orElseThrow(() -> new IllegalArgumentException("Procedimento n\u00e3o encontrado com o ID: " + procedimentoId));
        List horariosTrabalho = profissional.getHorariosTrabalho().stream().filter(horario -> horario.getDiaSemana().getValor() == data.getDayOfWeek().getValue()).collect(Collectors.toList());
        if (horariosTrabalho.isEmpty()) {
            return horariosDisponiveis;
        }
        LocalTime horarioInicioIntervalo = ((HorarioTrabalho)horariosTrabalho.get(0)).getIntervaloInicio();
        LocalTime horarioFimIntervalo = ((HorarioTrabalho)horariosTrabalho.get(0)).getIntervaloFim();
        long intervaloMinutos = procedimento.getDuracaoMinutos() + procedimento.getIntervaloMinutos();
        LocalTime proximoHorario = ((HorarioTrabalho)horariosTrabalho.get(0)).getHorarioInicio();
        while (proximoHorario.plusMinutes(intervaloMinutos).isBefore(horarioInicioIntervalo)) {
            horariosDisponiveis.add(proximoHorario.toString());
            proximoHorario = proximoHorario.plusMinutes(intervaloMinutos);
        }
        proximoHorario = horarioFimIntervalo;
        while (proximoHorario.plusMinutes(intervaloMinutos).isBefore(((HorarioTrabalho)horariosTrabalho.get(0)).getHorarioFim())) {
            horariosDisponiveis.add(proximoHorario.toString());
            proximoHorario = proximoHorario.plusMinutes(intervaloMinutos);
        }
        return horariosDisponiveis;
    }
}

